/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.provider.KeyProtector;

public final class JavaKeyStore
extends KeyStoreSpi {
    public static final int MAGIC = -17957139;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    private Hashtable entries = new Hashtable();

    public int engineSize() {
        return this.entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            DataInputStream dataInputStream;
            MessageDigest messageDigest = null;
            CertificateFactory certificateFactory = null;
            Hashtable hashtable2 = null;
            ByteArrayInputStream byteArrayInputStream = null;
            byte[] byArray = null;
            if (inputStream == null) {
                return;
            }
            if (cArray != null) {
                messageDigest = this.getPreKeyedHash(cArray);
                dataInputStream = new DataInputStream(new DigestInputStream(inputStream, messageDigest));
            } else {
                dataInputStream = new DataInputStream(inputStream);
            }
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            if (n2 != -17957139 || n3 != 1 && n3 != 2) {
                throw new IOException("Invalid keystore format");
            }
            if (n3 == 1) {
                certificateFactory = CertificateFactory.getInstance("X509");
            } else {
                hashtable2 = new Hashtable(3);
            }
            this.entries.clear();
            int n4 = dataInputStream.readInt();
            for (int i2 = 0; i2 < n4; ++i2) {
                String string;
                Object object;
                int n5 = dataInputStream.readInt();
                if (n5 == 1) {
                    object = new KeyEntry(this);
                    string = dataInputStream.readUTF();
                    ((KeyEntry)object).date = new Date(dataInputStream.readLong());
                    try {
                        ((KeyEntry)object).protectedPrivKey = new byte[dataInputStream.readInt()];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Keysize too big");
                    }
                    dataInputStream.readFully(((KeyEntry)object).protectedPrivKey);
                    int n6 = dataInputStream.readInt();
                    try {
                        if (n6 > 0) {
                            ((KeyEntry)object).chain = new Certificate[n6];
                        }
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Too many certificates in chain");
                    }
                    for (int i3 = 0; i3 < n6; ++i3) {
                        if (n3 == 2) {
                            String string2 = dataInputStream.readUTF();
                            if (hashtable2.containsKey(string2)) {
                                certificateFactory = (CertificateFactory)hashtable2.get(string2);
                            } else {
                                certificateFactory = CertificateFactory.getInstance(string2);
                                hashtable2.put(string2, certificateFactory);
                            }
                        }
                        try {
                            byArray = new byte[dataInputStream.readInt()];
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            throw new IOException("Certificate too big");
                        }
                        dataInputStream.readFully(byArray);
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        ((KeyEntry)object).chain[i3] = certificateFactory.generateCertificate(byteArrayInputStream);
                        byteArrayInputStream.close();
                    }
                    this.entries.put(string, object);
                    continue;
                }
                if (n5 == 2) {
                    object = new TrustedCertEntry(this);
                    string = dataInputStream.readUTF();
                    ((TrustedCertEntry)object).date = new Date(dataInputStream.readLong());
                    if (n3 == 2) {
                        String string3 = dataInputStream.readUTF();
                        if (hashtable2.containsKey(string3)) {
                            certificateFactory = (CertificateFactory)hashtable2.get(string3);
                        } else {
                            certificateFactory = CertificateFactory.getInstance(string3);
                            hashtable2.put(string3, certificateFactory);
                        }
                    }
                    try {
                        byArray = new byte[dataInputStream.readInt()];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Certificate too big");
                    }
                    dataInputStream.readFully(byArray);
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ((TrustedCertEntry)object).cert = certificateFactory.generateCertificate(byteArrayInputStream);
                    byteArrayInputStream.close();
                    this.entries.put(string, object);
                    continue;
                }
                throw new IOException("Unrecognized keystore entry");
            }
            if (cArray != null) {
                byte[] byArray2 = messageDigest.digest();
                byte[] byArray3 = new byte[byArray2.length];
                dataInputStream.readFully(byArray3);
                for (int i4 = 0; i4 < byArray2.length; ++i4) {
                    if (byArray2[i4] == byArray3[i4]) continue;
                    throw new IOException("Keystore was tampered with, or password was incorrect");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            if (cArray == null) {
                throw new IllegalArgumentException("password can't be null");
            }
            MessageDigest messageDigest = this.getPreKeyedHash(cArray);
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(outputStream, messageDigest));
            dataOutputStream.writeInt(-17957139);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeInt(this.entries.size());
            Object object = this.entries.keys();
            while (object.hasMoreElements()) {
                byte[] byArray;
                String string = (String)object.nextElement();
                Object object2 = this.entries.get(string);
                if (object2 instanceof KeyEntry) {
                    dataOutputStream.writeInt(1);
                    dataOutputStream.writeUTF(string);
                    dataOutputStream.writeLong(((KeyEntry)object2).date.getTime());
                    dataOutputStream.writeInt(((KeyEntry)object2).protectedPrivKey.length);
                    dataOutputStream.write(((KeyEntry)object2).protectedPrivKey);
                    int n2 = ((KeyEntry)object2).chain == null ? 0 : ((KeyEntry)object2).chain.length;
                    dataOutputStream.writeInt(n2);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        byArray = ((KeyEntry)object2).chain[i2].getEncoded();
                        dataOutputStream.writeUTF(((KeyEntry)object2).chain[i2].getType());
                        dataOutputStream.writeInt(byArray.length);
                        dataOutputStream.write(byArray);
                    }
                    continue;
                }
                dataOutputStream.writeInt(2);
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeLong(((TrustedCertEntry)object2).date.getTime());
                byArray = ((TrustedCertEntry)object2).cert.getEncoded();
                dataOutputStream.writeUTF(((TrustedCertEntry)object2).cert.getType());
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
            }
            object = messageDigest.digest();
            dataOutputStream.write((byte[])object);
            dataOutputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            this.entries.remove(string.toLowerCase());
        }
    }

    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string.toLowerCase());
    }

    public boolean engineIsCertificateEntry(String string) {
        Object object = this.entries.get(string.toLowerCase());
        return object != null && object instanceof TrustedCertEntry;
    }

    public boolean engineIsKeyEntry(String string) {
        Object object = this.entries.get(string.toLowerCase());
        return object != null && object instanceof KeyEntry;
    }

    private MessageDigest getPreKeyedHash(char[] cArray) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        int n2;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        byte[] byArray = new byte[cArray.length * 2];
        int n3 = 0;
        for (n2 = 0; n2 < cArray.length; ++n2) {
            byArray[n3++] = (byte)(cArray[n2] >> 8);
            byArray[n3++] = (byte)cArray[n2];
        }
        messageDigest.update(byArray);
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byArray[n2] = 0;
        }
        messageDigest.update("Mighty Aphrodite".getBytes("UTF8"));
        return messageDigest;
    }

    public Enumeration engineAliases() {
        return this.entries.keys();
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object object = this.entries.get(string);
            if (object instanceof TrustedCertEntry) {
                certificate2 = ((TrustedCertEntry)object).cert;
            } else {
                if (((KeyEntry)object).chain == null) continue;
                certificate2 = ((KeyEntry)object).chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        Object object = this.entries.get(string.toLowerCase());
        if (object == null || !(object instanceof KeyEntry)) {
            return null;
        }
        KeyProtector keyProtector = new KeyProtector(cArray);
        byte[] byArray = ((KeyEntry)object).protectedPrivKey;
        try {
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
        }
        catch (IOException iOException) {
            throw new UnrecoverableKeyException("Private key not stored as PKCS #8 EncryptedPrivateKeyInfo");
        }
        return keyProtector.recover(encryptedPrivateKeyInfo);
    }

    public Certificate engineGetCertificate(String string) {
        Object object = this.entries.get(string.toLowerCase());
        if (object != null) {
            if (object instanceof TrustedCertEntry) {
                return ((TrustedCertEntry)object).cert;
            }
            if (((KeyEntry)object).chain == null) {
                return null;
            }
            return ((KeyEntry)object).chain[0];
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Object object = this.entries.get(string.toLowerCase());
        if (object != null && object instanceof KeyEntry) {
            if (((KeyEntry)object).chain == null) {
                return null;
            }
            return (Certificate[])((KeyEntry)object).chain.clone();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object = this.entries.get(string.toLowerCase());
            if (object != null && object instanceof KeyEntry) {
                throw new KeyStoreException("Cannot overwrite own certificate");
            }
            TrustedCertEntry trustedCertEntry = new TrustedCertEntry(this);
            trustedCertEntry.cert = certificate;
            trustedCertEntry.date = new Date();
            this.entries.put(string.toLowerCase(), trustedCertEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            try {
                new EncryptedPrivateKeyInfo(byArray);
            }
            catch (IOException iOException) {
                throw new KeyStoreException("key is not encoded as EncryptedPrivateKeyInfo");
            }
            KeyEntry keyEntry = new KeyEntry(this);
            keyEntry.date = new Date();
            keyEntry.protectedPrivKey = (byte[])byArray.clone();
            keyEntry.chain = certificateArray != null && certificateArray.length != 0 ? (Certificate[])certificateArray.clone() : null;
            this.entries.put(string.toLowerCase(), keyEntry);
        }
    }

    public Date engineGetCreationDate(String string) {
        Object object = this.entries.get(string.toLowerCase());
        if (object != null) {
            if (object instanceof TrustedCertEntry) {
                return new Date(((TrustedCertEntry)object).date.getTime());
            }
            return new Date(((KeyEntry)object).date.getTime());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        KeyProtector keyProtector = null;
        try {
            Hashtable hashtable = this.entries;
            synchronized (hashtable) {
                KeyEntry keyEntry = new KeyEntry(this);
                keyEntry.date = new Date();
                keyProtector = new KeyProtector(cArray);
                keyEntry.protectedPrivKey = keyProtector.protect(key);
                keyEntry.chain = certificateArray != null && certificateArray.length != 0 ? (Certificate[])certificateArray.clone() : null;
                this.entries.put(string.toLowerCase(), keyEntry);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException("Key protection algorithm not found");
        }
        finally {
            keyProtector = null;
        }
    }

    class KeyEntry {
        Date date;
        byte[] protectedPrivKey;
        Certificate[] chain;
        private final JavaKeyStore this$0;

        KeyEntry(JavaKeyStore javaKeyStore) {
            this.this$0 = javaKeyStore;
        }
    }

    class TrustedCertEntry {
        Date date;
        Certificate cert;
        private final JavaKeyStore this$0;

        TrustedCertEntry(JavaKeyStore javaKeyStore) {
            this.this$0 = javaKeyStore;
        }
    }
}

